﻿using System.Net;
using System.Net.Http;
using System.Threading.Tasks;
using log4net;
using Microsoft.AspNetCore.Mvc;
using Microsoft.Extensions.Logging;
using Moq;
using VA.PPMS.IWS.Api.Configuration.Interface;
using VA.PPMS.IWS.Api.Controllers;
using VA.PPMS.IWS.Api.HttpClientHandler.Interface;
using VA.PPMS.IWS.Common;
using Xunit;

namespace VA.PPMS.IWS.Api.Unit.Test
{
    public class DasOperationOutcomeControllerTests
    {
        [Fact]
        public void TestDasOperationOutcomeReturns201()
        {
            // Arrange
            var mockLogger = new Mock<ILog>();
            mockLogger.Setup(x => x.Info(It.IsAny<object>()));
            mockLogger.Setup(x => x.Error(It.IsAny<object>()));

            var mockConfiguration = new Mock<IIwsConfiguration>();

            var mockClient = new Mock<IHttpClientHandler>();
            mockClient.Setup(x => x.PostAsync(It.IsAny<string>(), It.IsAny<DasMessage>())).Returns(Task.FromResult(new HttpResponseMessage(HttpStatusCode.Created)));

            var controller = new DasOperationOutcomeController(mockLogger.Object, mockConfiguration.Object, mockClient.Object) { ControllerContext = UnitTestHelper.CreateControllerContext() };
            const string fhirMessage = "{'resourceType': 'OperationOutcome','id': 'exception','text': {'status': 'additional','div': 'Bad Request: File scanning of attachment(s)'},'issue': [{'severity': 'error','code': 'exception','details': {'text': 'File scanning of attachment(s) failed'}}]}";

            // Act
            var results = controller.Post(fhirMessage);
            var statusCodeResult = results.GetAwaiter().GetResult() as StatusCodeResult;

            // Assert
            Assert.NotNull(statusCodeResult);
            Assert.Equal(201, statusCodeResult.StatusCode);
        }

        [Fact]
        public void TestDasOperationOutcomeNoIdReturns501()
        {
            // Arrange
            var mockLogger = new Mock<ILog>();
            mockLogger.Setup(x => x.Info(It.IsAny<object>()));
            mockLogger.Setup(x => x.Error(It.IsAny<object>()));

            var mockConfiguration = new Mock<IIwsConfiguration>();

            var mockClient = new Mock<IHttpClientHandler>();
            mockClient.Setup(x => x.PostAsync(It.IsAny<string>(), It.IsAny<DasMessage>())).Returns(Task.FromResult(new HttpResponseMessage(HttpStatusCode.InternalServerError)));

            var controller = new DasOperationOutcomeController(mockLogger.Object, mockConfiguration.Object, mockClient.Object) { ControllerContext = UnitTestHelper.CreateControllerContext() };
            const string fhirMessage = "{'resourceType': 'OperationOutcome','id': '','text': {'status': 'additional','div': 'Bad Request: File scanning of attachment(s)'},'issue': [{'severity': 'error','code': 'exception','details': {'text': 'File scanning of attachment(s) failed'}}]}";

            // Act
            var results = controller.Post(fhirMessage);
            var statusCodeResult = results.GetAwaiter().GetResult() as ObjectResult;

            // Assert
            Assert.NotNull(statusCodeResult);
            Assert.Equal(500, statusCodeResult.StatusCode);
            Assert.Equal("DasOperationOutcomeController: OperationalOutcome is missing data required to process the information", statusCodeResult.Value);
        }

        [Fact]
        public void TestDasOperationOutcomePostToFunctionErrorReturns500()
        {
            // Arrange
            var mockLogger = new Mock<ILog>();
            mockLogger.Setup(x => x.Info(It.IsAny<object>()));
            mockLogger.Setup(x => x.Error(It.IsAny<object>()));

            var mockConfiguration = new Mock<IIwsConfiguration>();

            var mockClient = new Mock<IHttpClientHandler>();
            mockClient.Setup(x => x.PostAsync(It.IsAny<string>(), It.IsAny<DasMessage>())).Returns(Task.FromResult(new HttpResponseMessage(HttpStatusCode.InternalServerError)));

            var controller = new DasOperationOutcomeController(mockLogger.Object, mockConfiguration.Object, mockClient.Object) { ControllerContext = UnitTestHelper.CreateControllerContext() };
            const string fhirMessage = "{'resourceType': 'OperationOutcome','id': 'exception','text': {'status': 'additional','div': 'Bad Request: File scanning of attachment(s)'},'issue': [{'severity': 'error','code': 'exception','details': {'text': 'File scanning of attachment(s) failed'}}]}";

            // Act
            var results = controller.Post(fhirMessage);
            var statusCodeResult = results.GetAwaiter().GetResult() as ObjectResult;

            // Assert
            Assert.NotNull(statusCodeResult);
            Assert.Equal(500, statusCodeResult.StatusCode);
            Assert.Equal("DasOperationOutcomeController POST Exception", statusCodeResult.Value);
        }
    }
}